
from gurobipy import *

# Create a new model
m = Model("Ice_Cream_Truck_Optimization")

# Define the decision variables
x_s = m.addVar(lb=10, ub=20, name="strawberry_cakes")  # Number of strawberry ice cream cakes
x_m = m.addVar(lb=20, ub=40, name="mint_cakes")        # Number of mint ice cream cakes

# Define the objective function: Maximize profit
m.setObjective(2.5*x_s + 4*x_m, GRB.MAXIMIZE)

# Add the constraint for total cakes
m.addConstr(x_s + x_m <= 50, name="total_cakes_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Strawberry ice cream cakes to produce: {x_s.x}")
    print(f"Mint ice cream cakes to produce: {x_m.x}")
    print(f"Total profit: ${2.5*x_s.x + 4*x_m.x:.2f}")
else:
    print("No optimal solution found.")
