
import gurobi

def solve_ice_cream_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=10, ub=20, name="strawberry_cakes")
    x2 = model.addVar(lb=20, ub=40, name="mint_cakes")

    # Objective function: Maximize profit
    model.setObjective(2.5 * x1 + 4 * x2, gurobi.GRB.MAXIMIZE)

    # Constraint: Total cakes cannot exceed 50
    model.addConstr(x1 + x2 <= 50, name="total_cakes")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Profit: {model.objVal}")
        print(f"Strawberry cakes: {x1.x}, Mint cakes: {x2.x}")
    else:
        print("No optimal solution found.")

# Run the function
solve_ice_cream_problem()
