
import gurobipy as gp

# Create a new model
model = gp.Model("CookieProfit")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chocolate_cookies")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberry_cookies")

# Set objective function
model.setObjective(1.5 * x + 1.2 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 200, "total_cookies")
model.addConstr(x >= 50, "min_chocolate")
model.addConstr(y >= 70, "min_strawberry")
model.addConstr(x <= 120, "max_chocolate")
model.addConstr(y <= 150, "max_strawberry")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Chocolate Cookies: {x.x}")
    print(f"Strawberry Cookies: {y.x}")
    print(f"Maximum Profit: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

