
from gurobipy import *

# Create a new model
m = Model("Cookie_Profit")

# Define decision variables
x = m.addVar(name='chocolate_cookies', lb=50, ub=120)  # Number of chocolate cookies
y = m.addVar(name='strawberry_cookies', lb=70, ub=150)  # Number of strawberry cookies

# Set the objective function to maximize profit
m.setObjective(1.5*x + 1.2*y, GRB.MAXIMIZE)

# Add constraint for total number of cookies
m.addConstr(x + y <= 200, name='total_cookies')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
