
import gurobi

def solve_cookie_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=50, ub=120, name="Chocolate Cookies")
    y = model.addVar(lb=70, ub=150, name="Strawberry Cookies")

    # Objective function: Maximize 1.5x + 1.2y
    model.setObjective(1.5 * x + 1.2 * y, gurobi.GRB.MAXIMIZE)

    # Total cookies constraint: x + y <= 200
    model.addConstraint(x + y <= 200)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Chocolate Cookies = {x.varValue}, Strawberry Cookies = {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_cookie_problem()
