
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("BeanProduction")

# Create decision variables
x = m.addVar(lb=0, name="cocoa_beans")  # Tons of cocoa beans
y = m.addVar(lb=0, name="coffee_beans") # Tons of coffee beans

# Set objective function
m.setObjective(500*x + 750*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 15, "production_capacity")
m.addConstr(15*x + 15*y <= 1000, "roasting_time")
m.addConstr(x >= 3, "min_cocoa")
m.addConstr(y >= 5, "min_coffee")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Cocoa Beans (tons): {x.x}")
    print(f"Coffee Beans (tons): {y.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

