
from gurobipy import *

# Create a new model
m = Model("Bean_Production")

# Define variables
x_c = m.addVar(name="cocoa_beans", lb=3)  # Minimum of 3 tons of cocoa beans
x_cf = m.addVar(name="coffee_beans", lb=5)  # Minimum of 5 tons of coffee beans

# Objective function: Maximize profit
m.setObjective(500*x_c + 750*x_cf, GRB.MAXIMIZE)

# Constraints
# Production capacity constraint
m.addConstr(x_c + x_cf <= 15, name="production_capacity")

# Roasting machine availability constraint
m.addConstr(15*x_c + 15*x_cf <= 1000, name="roasting_machine_availability")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cocoa beans to produce: {x_c.x}")
    print(f"Coffee beans to produce: {x_cf.x}")
else:
    print("No optimal solution found. The model is likely infeasible.")

