
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="cocoa_beans")
    y = model.addVar(lb=0, name="coffee_beans")

    # Objective function: Maximize profit
    model.setObjective(500*x + 750*y, gurobi.GRB.MAXIMIZE)

    # Production capacity constraint
    model.addConstr(x + y <= 15, name="production_capacity")

    # Roasting time constraint
    model.addConstr(15*x + 15*y <= 1000, name="roasting_time")

    # Minimum production requirements
    model.addConstr(x >= 3, name="min_cocoa_beans")
    model.addConstr(y >= 5, name="min_coffee_beans")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: {x.varName} = {x.x}, {y.varName} = {y.x}")
        print(f"Maximum profit: ${model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_optimization_problem()
