
import gurobipy as gp

# Create a new model
m = gp.Model("ball_throwing_game")

# Create variables
x = m.addVar(vtype=gp.GRB.INTEGER, name="small_balls")
y = m.addVar(vtype=gp.GRB.INTEGER, name="large_balls")

# Set objective function
m.setObjective(5*x + 2*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 20, "total_balls")
m.addConstr(x >= 6, "min_small_balls")
m.addConstr(y >= 5, "min_large_balls")
m.addConstr(x <= 12, "max_small_balls")
m.addConstr(y <= 12, "max_large_balls")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal score: {m.objVal}")
    print(f"Number of small balls: {x.x}")
    print(f"Number of large balls: {y.x}")
else:
    print("Infeasible or unbounded")

