
from gurobipy import *

# Create a new model
m = Model("Ball_Throwing_Optimization")

# Define variables
x_s = m.addVar(name="small_balls", lb=6, ub=12)  # Number of small balls thrown
x_l = m.addVar(name="large_balls", lb=5, ub=12)  # Number of large balls thrown

# Set the objective function: Maximize the total score
m.setObjective(5*x_s + 2*x_l, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_s + x_l <= 20, name="total_balls")  # Total balls constraint

# Solve the model
m.optimize()

# Check if an optimal solution was found
if m.status == GRB.OPTIMAL:
    print(f"Optimal score: {m.objVal}")
    print(f"Throw {x_s.x} small balls and {x_l.x} large balls.")
else:
    print("No optimal solution found. The model may be infeasible.")

# Print the Gurobi model
m.printStats()
