
import gurobi

def maximize_score():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x_s = model.addVar(lb=6, ub=12, name="small_balls")  # At least 6, no more than 12
    x_l = model.addVar(lb=5, ub=12, name="large_balls")  # At least 5, no more than 12

    # Objective function: Maximize 5x_s + 2x_l
    model.setObjective(5 * x_s + 2 * x_l, gurobi.GRB.MAXIMIZE)

    # Total balls constraint: x_s + x_l <= 20
    model.addConstr(x_s + x_l <= 20, name="total_balls")

    # Solve the model
    model.optimize()

    # Get the optimized values
    if model.status == gurobi.GRB.OPTIMAL:
        small_balls = x_s.varValue
        large_balls = x_l.varValue
        max_score = 5 * small_balls + 2 * large_balls
        print(f"Optimal Strategy: Throw {small_balls} small balls and {large_balls} large balls.")
        print(f"Maximum Score: {max_score}")
    else:
        print("The model is infeasible.")

maximize_score()
