
from gurobipy import Model, GRB

# Create a new model
m = Model("TrainTicketing")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="general_class")
y = m.addVar(vtype=GRB.INTEGER, name="sleeper_class")

# Set objective function
m.setObjective(200 * y + 80 * x, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 400, "capacity")
m.addConstr(y >= 50, "min_sleeper")
m.addConstr(x >= 1.5 * y, "general_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"General Class Tickets: {x.x}")
    print(f"Sleeper Class Tickets: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No solution found.")

