
from gurobipy import *

# Create a new model
m = Model("Train_Ticket_Optimization")

# Define variables
S = m.addVar(vtype=GRB.CONTINUOUS, name="sleeper_class_tickets", lb=0)
G = m.addVar(vtype=GRB.CONTINUOUS, name="general_class_tickets", lb=0)

# Define the objective function: Maximize profit
m.setObjective(200*S + 80*G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(S + G <= 400, "total_passengers")
m.addConstr(S >= 50, "min_sleeper_class")
m.addConstr(G >= 1.5*S, "general_vs_sleeper")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sleeper class tickets: {S.x}")
    print(f"General class tickets: {G.x}")
    print(f"Maximum profit: ${200*S.x + 80*G.x}")
else:
    print("No optimal solution found")

