
import gurobi

def solve_train_ticket_problem():
    # Create a new model
    m = gurobi.Model()

    # Decision variables
    x = m.addVar(name="general_class_tickets", lb=0, vtype=gurobi.GRB.INTEGER)
    y = m.addVar(name="sleeper_class_tickets", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    m.setObjective(80 * x + 200 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(x + y <= 400, name="total_passengers")
    m.addConstr(y >= 50, name="sleeper_class_min")
    m.addConstr(x >= 1.5 * y, name="general_vs_sleeper_ratio")

    # Solve the model
    m.optimize()

    if m.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal Solution: General Class Tickets = {x.varValue}, Sleeper Class Tickets = {y.varValue}")
        print(f"Maximum Profit: ${80 * x.varValue + 200 * y.varValue}")
    else:
        print("The model is infeasible.")

solve_train_ticket_problem()
