
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Optimization")

# Create decision variables
x = m.addVar(nonnegative=True, name="Energy_Investment")
y = m.addVar(nonnegative=True, name="Travel_Investment")

# Set objective function
m.setObjective(0.32 * x + 0.20 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y == 10, "Total_Investment")
m.addConstr(x >= 2.5, "Min_Energy_Investment")
m.addConstr(y <= 5, "Max_Travel_Investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in Energy: ${x.x:.2f} million")
    print(f"Optimal investment in Travel: ${y.x:.2f} million")
    print(f"Maximum total return: ${m.objVal:.2f} million")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

