
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
xe = m.addVar(lb=2500000, name="energy_investment")
xt = m.addVar(ub=5000000, name="travel_investment")

# Objective function: Maximize return
m.setObjective(0.32*xe + 0.20*xt, GRB.MAXIMIZE)

# Constraint: Total investment is $10 million
m.addConstr(xe + xt == 10000000, "total_investment")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Energy Sector Investment: ${xe.x}")
    print(f"Travel Sector Investment: ${xt.x}")
    print(f"Total Return: ${0.32*xe.x + 0.20*xt.x}")
else:
    print("No optimal solution found")
