
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Optimization")

# Define variables
E = m.addVar(name="Energy", lb=0)  # Investment in energy sector
T = m.addVar(name="Travel", lb=0)  # Investment in travel sector

# Objective function: Maximize return
m.setObjective(0.32 * E + 0.20 * T, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(E + T == 10_000_000, name="Total_Investment")  # Total investment constraint
m.addConstr(E >= 2_500_000, name="Min_Energy")  # Minimum energy sector investment
m.addConstr(T <= 5_000_000, name="Max_Travel")  # Maximum travel sector investment

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in energy sector: ${E.varValue}")
    print(f"Optimal investment in travel sector: ${T.varValue}")
    print(f"Max return: ${0.32 * E.varValue + 0.20 * T.varValue}")
else:
    print("The model is infeasible")
