
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pierre_ecommerce")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="sandals") # Number of sandals
y = m.addVar(vtype=GRB.INTEGER, name="slippers") # Number of slippers

# Set objective function: Maximize profit
m.setObjective(70*x + 30*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 3*y, "demand") # Demand constraint
m.addConstr(50*x + 20*y <= 3000, "budget") # Budget constraint

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of sandals to buy: {x.x}")
    print(f"Number of slippers to buy: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

