
from gurobipy import *

# Create a new model
m = Model("Pierre_eCommerce")

# Define the decision variables
S = m.addVar(lb=0, vtype=GRB.INTEGER, name="Sandals")
L = m.addVar(lb=0, vtype=GRB.INTEGER, name="Slippers")

# Set the objective function to maximize profit
m.setObjective(70*S + 30*L, GRB.MAXIMIZE)

# Add constraints
m.addConstr(S >= 3*L, "DemandConstraint")
m.addConstr(50*S + 20*L <= 3000, "BudgetConstraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {S.x} sandals and {L.x} slippers")
    print(f"Maximum profit: ${70*S.x + 30*L.x}")
else:
    print("No optimal solution found")

