
import gurobi

def pierre_ecommerce_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(name="sandals", lb=0, vtype=gurobi.GRB.INTEGER)
    y = model.addVar(name="slippers", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize profit
    model.setObjective(70 * x + 30 * y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(50 * x + 20 * y <= 3000, name="budget")

    # Demand constraint
    model.addConstr(x >= 3 * y, name="demand")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${70 * x.varValue + 30 * y.varValue}")
    else:
        print("No optimal solution found")

    return model

# Run the model
model = pierre_ecommerce_problem()
