
import gurobipy as gp

# Create a new model
model = gp.Model("PuzzleProduction")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="small_puzzles")
y = model.addVar(vtype=gp.GRB.INTEGER, name="large_puzzles")

# Set objective function
model.setObjective(8*x + 12*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 15*y <= 600, "cutting_time")
model.addConstr(20*x + 30*y <= 1000, "quality_checking_time")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small puzzles: {x.x}")
    print(f"Number of large puzzles: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

