
from gurobipy import *

# Create a new model
m = Model("Puzzle_Optimization")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="small_puzzles")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="large_puzzles")

# Set the objective function to maximize profit
m.setObjective(8*x + 12*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 15*y <= 600, "cutting_time")
m.addConstr(20*x + 30*y <= 1000, "quality_checking_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x.x} small puzzles and {y.x} large puzzles.")
else:
    print("No optimal solution found. The problem might be infeasible.")

