
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
S = model.addVar(lb=0, name="Small_Puzzles")
L = model.addVar(lb=0, name="Large_Puzzles")

# Define the objective function
model.setObjective(8 * S + 12 * L, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(10 * S + 15 * L <= 600, name="Cutting_Time")
model.addConstr(20 * S + 30 * L <= 1000, name="Quality_Checking_Time")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Small Puzzles: {S.varValue}")
    print(f"Large Puzzles: {L.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
