
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("SeasoningMix")

# Create variables
x = model.addVar(lb=0, name="Seasoning_A")
y = model.addVar(lb=0, name="Seasoning_B")

# Set objective function
model.setObjective(1.5 * x + 3 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * x + y >= 5, "PepperConstraint")
model.addConstr(x + 4 * y >= 6, "SaltConstraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Seasoning A (kg): {x.x:.2f}")
    print(f"Seasoning B (kg): {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

