
from gurobipy import *

# Create a new model
m = Model("Seasoning_Optimization")

# Define the decision variables
x_A = m.addVar(name="Seasoning_A", lb=0)
x_B = m.addVar(name="Seasoning_B", lb=0)

# Set the objective function: minimize total cost
m.setObjective(1.50*x_A + 3*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x_A + x_B >= 5, name="Pepper_Constraint")
m.addConstr(x_A + 4*x_B >= 6, name="Salt_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x_A.varName} = {x_A.x}, {x_B.varName} = {x_B.x}")
    print(f"Total cost: ${1.50*x_A.x + 3*x_B.x:.2f}")
else:
    print("No optimal solution found")

