
import gurobi

def solve_seasoning_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="Seasoning_A", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="Seasoning_B", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Minimize 1.5x + 3y
    model.setObjective(1.5 * x + 3 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x + y >= 5, name="pepper_requirement")
    model.addConstr(x + 4 * y >= 6, name="salt_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of Seasoning A: {x.varValue} kg")
        print(f"Optimal amount of Seasoning B: {y.varValue} kg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

if __name__ == "__main__":
    solve_seasoning_problem()
