
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bus_seating")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="bottom_deck")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="top_deck")

# Set objective function
m.setObjective(25*x + 35*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50, "capacity")
m.addConstr(x >= 10, "min_bottom")
m.addConstr(y >= 2*x, "top_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal bottom deck seats: {x.x}")
    print(f"Optimal top deck seats: {y.x}")
    print(f"Optimal profit: {m.objVal}")
else:
    print("Infeasible or unbounded")

