
from gurobipy import *

# Create a new model
m = Model("Bus_Seat_Optimization")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="bottom_deck_seats")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="top_deck_seats")

# Set the objective function
m.setObjective(25*x + 35*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 50, "total_capacity")
m.addConstr(x >= 10, "min_bottom_deck")
m.addConstr(y >= 2*x, "passenger_preference")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bottom deck seats: {x.x}")
    print(f"Top deck seats: {y.x}")
    print(f"Maximum profit: ${25*x.x + 35*y.x}")
else:
    print("No optimal solution found")
