
import gurobi

def solve_bus_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x = model.addVar(lb=0, name="bottom_deck_seats", vtype=gurobi.GRB.INTEGER)
    y = model.addVar(lb=0, name="top_deck_seats", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(25 * x + 35 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 50, name="total_passengers")
    model.addConstr(x >= 10, name="min_bottom_deck_seats")
    model.addConstr(y >= 2 * x, name="top_deck_preference")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: bottom deck seats = {x.varValue}, top deck seats = {y.varValue}")
        print(f"Max Profit: ${25 * x.varValue + 35 * y.varValue}")
    else:
        print("No optimal solution found")

solve_bus_seating_problem()
