
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("LitchiShipping")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="boat_trips")
y = m.addVar(vtype=GRB.INTEGER, name="plane_trips")

# Set objective function
m.setObjective(500 * x + 200 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5000 * x + 3000 * y <= 200000, "budget")
m.addConstr(x <= y, "trip_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of boat trips: {x.x}")
    print(f"Number of plane trips: {y.x}")
    print(f"Total boxes shipped: {500 * x.x + 200 * y.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

