
from gurobipy import *

# Create a model
m = Model("Litchi_Shipment")

# Define decision variables
x = m.addVar(vtype=GRB.INTEGER, name="boat_trips")
y = m.addVar(vtype=GRB.INTEGER, name="cargo_plane_trips")

# Set the objective function: Maximize the total boxes of litchis delivered
m.setObjective(500*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5000*x + 3000*y <= 200000, "budget_constraint")
m.addConstr(x <= y, "trip_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of boat trips: {x.x}")
    print(f"Number of cargo plane trips: {y.x}")
    print(f"Total boxes delivered: {500*x.x + 200*y.x}")
else:
    print("No optimal solution found")
