
import gurobi

def litchi_transportation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    B = model.addVar(name="boat_trips", vtype=gurobi.GRB.INTEGER, lb=0)
    P = model.addVar(name="plane_trips", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: Maximize the total boxes of litchis transported
    model.setObjective(500*B + 200*P, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(5000*B + 3000*P <= 200000, name="budget_constraint")

    # Boat and plane trip constraint
    model.addConstr(B <= P, name="boat_plane_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Boat trips = {B.varValue}, Plane trips = {P.varValue}")
        print(f"Maximum boxes of litchis delivered: {500*B.varValue + 200*P.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model status is not optimal or infeasible.")

# Run the function
litchi_transportation_problem()
