
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("mia_clothing")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="skirts")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="coats")

# Set objective
m.setObjective(300 * x + 500 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * x + 2 * y <= 25, "sewing_constraint")
m.addConstr(5 * x + 3.5 * y <= 35, "embroidery_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of skirts to produce: {x.x}")
    print(f"Number of coats to produce: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

