
from gurobipy import *

# Create a new model
model = Model("Mia_Clothing")

# Define the decision variables
S = model.addVar(vtype=GRB.CONTINUOUS, name="Skirts", lb=0)
C = model.addVar(vtype=GRB.CONTINUOUS, name="Coats", lb=0)

# Define the objective function
model.setObjective(300*S + 500*C, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*S + 2*C <= 25, "Sewing_Machine_Constraint")
model.addConstr(5*S + 3.5*C <= 35, "Embroidery_Machine_Constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Skirts: {S.x}")
    print(f"Coats: {C.x}")
    print(f"Maximum Profit: ${300*S.x + 500*C.x:.2f}")
else:
    print("No optimal solution found")
