
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="Skirts")
    y = model.addVar(lb=0, name="Coats")

    # Objective function: Maximize profit
    model.setObjective(300*x + 500*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x + 2*y <= 25, name="Sewing_Machine_Constraint")
    model.addConstr(5*x + 3.5*y <= 35, name="Embroidery_Machine_Constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal production levels:")
        print(f"Skirts: {x.varValue}")
        print(f"Coats: {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_production_problem()
