
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("berry_farm")

# Create variables
x = m.addVar(lb=0, name="cranberries") # Acres of cranberries
y = m.addVar(lb=0, name="bilberries") # Acres of bilberries

# Set objective function
m.setObjective(66*x + 73*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 250, "land")
m.addConstr(25*x + 30*y <= 9000, "watering")
m.addConstr(5*x + 4*y <= 600, "labor")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of cranberries")
    print(f"Plant {y.x:.2f} acres of bilberries")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

