
from gurobipy import *

# Create a new model
m = Model("Berry Farm Optimization")

# Define decision variables
cranberries_acres = m.addVar(lb=0, name="Cranberries_Acres")
bilberries_acres = m.addVar(lb=0, name="Bilberries_Acres")

# Objective function: Maximize profit
m.setObjective(66*cranberries_acres + 73*bilberries_acres, GRB.MAXIMIZE)

# Constraint 1: Labor constraint
m.addConstr(5*cranberries_acres + 4*bilberries_acres <= 600, name="Labor_Constraint")

# Constraint 2: Watering cost constraint
m.addConstr(25*cranberries_acres + 30*bilberries_acres <= 9000, name="Watering_Cost_Constraint")

# Constraint 3: Total land constraint
m.addConstr(cranberries_acres + bilberries_acres <= 250, name="Total_Land_Constraint")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Cranberries Acres: {cranberries_acres.x}")
    print(f"Bilberries Acres: {bilberries_acres.x}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
