
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="cranberries")  # acres of cranberries
y = model.addVar(lb=0, name="bilberries")  # acres of bilberries

# Define the objective function
model.setObjective(66 * x + 73 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(5 * x + 4 * y <= 600, name="labor")  # labor constraint
model.addConstr(25 * x + 30 * y <= 9000, name="watering")  # watering constraint
model.addConstr(x + y <= 250, name="land")  # land constraint

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Cranberries: {x.varValue} acres")
    print(f"Bilberries: {y.varValue} acres")
    print(f"Max profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
