
import gurobipy as gp

# Create a new model
m = gp.Model("John's Diet")

# Create variables
x = m.addVar(lb=0, name="pears")  # Pounds of pears
y = m.addVar(lb=0, name="broccoli") # Pounds of broccoli

# Set objective function
m.setObjective(6*x + 8*y, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 4*y >= 15, "calcium")
m.addConstr(5*x + 3*y >= 20, "potassium")
m.addConstr(3*x + 6*y >= 17, "magnesium")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Pounds of pears: {x.x:.2f}")
    print(f"Pounds of broccoli: {y.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

