
from gurobipy import *

# Create a new model
m = Model("Johns_Diet")

# Define the decision variables
pears = m.addVar(vtype=GRB.CONTINUOUS, name="Pears")
broccoli = m.addVar(vtype=GRB.CONTINUOUS, name="Broccoli")

# Objective function: Minimize cost
m.setObjective(6*pears + 8*broccoli, GRB.MINIMIZE)

# Constraints
m.addConstr(2*pears + 4*broccoli >= 15, "Calcium_Requirement")
m.addConstr(5*pears + 3*broccoli >= 20, "Potassium_Requirement")
m.addConstr(3*pears + 6*broccoli >= 17, "Magnesium_Requirement")

# Non-negativity constraints are handled by the CONTINUOUS variable type

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pounds of Pears: {pears.X}")
    print(f"Pounds of Broccoli: {broccoli.X}")
    print(f"Total Cost: ${6*pears.X + 8*broccoli.X:.2f}")
else:
    print("No optimal solution found. The model may be infeasible.")
