
import gurobi

def solve_nutrition_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="pears")  # pounds of pears
    y = model.addVar(lb=0, name="broccoli")  # pounds of broccoli

    # Objective: Minimize the total cost
    model.setObjective(6*x + 8*y, gurobi.GRB.MINIMIZE)

    # Constraints for the daily nutritional requirements
    model.addConstr(2*x + 4*y >= 15, name="calcium_requirement")
    model.addConstr(5*x + 3*y >= 20, name="potassium_requirement")
    model.addConstr(3*x + 6*y >= 17, name="magnesium_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Pears (pounds): {x.varValue}")
        print(f"Broccoli (pounds): {y.varValue}")
        print(f"Total Cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible or unbounded.")

# Run the function
solve_nutrition_problem()
