
import gurobipy as gp

# Create a new model
m = gp.Model("ice_cream_optimization")

# Create decision variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vanilla")
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chocolate")

# Set objective function
m.setObjective(2*x + 3*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 20, "vanilla_min")
m.addConstr(x <= 50, "vanilla_max")
m.addConstr(y >= 25, "chocolate_min")
m.addConstr(y <= 60, "chocolate_max")
m.addConstr(x + y <= 80, "total_cones")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Vanilla Cones: {x.x}")
    print(f"Chocolate Cones: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

