
from gurobipy import *

# Create a new model
model = Model("Ice_Cream_Profit")

# Define variables
v = model.addVar(lb=20, ub=50, vtype=GRB.INTEGER, name="vanilla_cones")
c = model.addVar(lb=25, ub=60, vtype=GRB.INTEGER, name="chocolate_cones")

# Set the objective function to maximize profit
model.setObjective(2*v + 3*c, GRB.MAXIMIZE)

# Add the constraint for total cones
model.addConstr(v + c <= 80, "total_cones_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vanilla cones: {v.x}")
    print(f"Chocolate cones: {c.x}")
    print(f"Total profit: ${2*v.x + 3*c.x}")
else:
    print("No optimal solution found")
