
import gurobi

def solve_ice_cream_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    V = model.addVar(lb=20, ub=50, name="Vanilla")
    C = model.addVar(lb=25, ub=60, name="Chocolate")

    # Objective function: Maximize profit
    model.setObjective(2 * V + 3 * C, gurobi.GRB.MAXIMIZE)

    # Constraint: Total cones cannot exceed 80
    model.addConstr(V + C <= 80, name="TotalCones")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Vanilla = {V.varValue}, Chocolate = {C.varValue}")
        print(f"Maximum Profit: ${2 * V.varValue + 3 * C.varValue}")
    else:
        print("The model is infeasible.")

solve_ice_cream_problem()
