
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("supplement_mix")

# Create variables
x = m.addVar(lb=0, name="orange")  # Orange drink servings
y = m.addVar(lb=0, name="apple")  # Apple drink servings

# Set objective function
m.setObjective(8*x + 5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x + 6*y >= 13, "fiber_req")
m.addConstr(5*x + 3*y >= 13, "iron_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Orange servings: {x.x:.2f}")
    print(f"Apple servings: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

