
from gurobipy import *

# Create a new model
m = Model("Fiber_and_Iron")

# Define variables
x1 = m.addVar(name="Orange_Flavored", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Apple_Flavored", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(8*x1 + 5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 6*x2 >= 13, name="Fiber_Constraint")
m.addConstr(5*x1 + 3*x2 >= 13, name="Iron_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Orange Flavored: {x1.x} servings")
    print(f"Apple Flavored: {x2.x} servings")
    print(f"Total Cost: ${8*x1.x + 5*x2.x}")
else:
    print("No optimal solution found.")
