
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="orange_servings")
y = model.addVar(lb=0, name="apple_servings")

# Define the objective function
model.setObjective(8*x + 5*y, gurobi.GRB.MINIMIZE)

# Define the constraints
fiber_constraint = model.addConstr(4*x + 6*y >= 13, name="fiber_intake")
iron_constraint = model.addConstr(5*x + 3*y >= 13, name="iron_intake")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Orange servings: {x.varValue}")
    print(f"Apple servings: {y.varValue}")
    print(f"Total cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
