
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("animal_catching")

    # Create variables
    f = m.addVar(vtype=GRB.INTEGER, name="fish")
    b = m.addVar(vtype=GRB.INTEGER, name="birds")

    # Set objective
    m.setObjective(4 * f + 6 * b, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(f >= 6, "min_fish")
    m.addConstr(b >= 2, "min_birds")
    m.addConstr(f <= 9, "max_fish")
    m.addConstr(b <= 4, "max_birds")
    m.addConstr(f + b <= 12, "total_animals")

    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print(f'Optimal solution found: Fish = {f.x}, Birds = {b.x}')
        print(f'Total points: {m.objVal}')
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f'Error code {e.errno}: {e}')

except AttributeError:
    print('Encountered an attribute error')

