
from gurobipy import *

# Create a new model
m = Model("Animal_Catching")

# Define the decision variables
F = m.addVar(name='Fish', vtype=GRB.INTEGER, lb=6, ub=9)  # At least 6 fish and at most 9 fish
B = m.addVar(name='Birds', vtype=GRB.INTEGER, lb=2, ub=4)  # At least 2 birds and at most 4 birds

# Define the objective function: Maximize points from catching fish and birds
m.setObjective(4*F + 6*B, GRB.MAXIMIZE)

# Add the constraint for the total number of animals caught
m.addConstr(F + B <= 12, name='Total_Animals')

# Optimize the model
m.optimize()

# Print out the solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Catch {F.x} fish')
    print(f'Catch {B.x} birds')
    print(f'Total points: {4*F.x + 6*B.x}')
else:
    print('No optimal solution found')

