
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    F = model.addVar(lb=0, ub=None, name="Fish")
    B = model.addVar(lb=0, ub=None, name="Birds")

    # Objective function: Maximize 4F + 6B
    model.setObjective(4 * F + 6 * B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(F >= 6, name="Fish_Min")
    model.addConstr(B >= 2, name="Birds_Min")
    model.addConstr(F <= 9, name="Fish_Max")
    model.addConstr(B <= 4, name="Birds_Max")
    model.addConstr(F + B <= 12, name="Total_Animals")

    # Integrate new variables and constraints
    model.update()

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal points: {model.objVal}")
        print(f"Fish to catch: {F.varValue}")
        print(f"Birds to catch: {B.varValue}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
